package org.msh.tb.bd.tbforms.input;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.msh.tb.entities.enums.TbFormField;

import java.util.Map;

/**
 * Created by Mauricio on 16/03/2017.
 * Specification that implements TB 11 form input
 */
@Name("tb11InputFormHome")
public class Tb11InputFormHome extends InputFormHome {

    @In(create=true) protected Map<String, String> messages;

    private TB11InputFormData data;

    private final TbFormField[] fields = new TbFormField[] {
            TbFormField.TB11_IPT_COLUMN1_MALE,
            TbFormField.TB11_IPT_COLUMN1_FEMALE,
            TbFormField.TB11_IPT_COLUMN2_MALE,
            TbFormField.TB11_IPT_COLUMN2_FEMALE,
            TbFormField.TB11_IPT_COLUMN3_MALE,
            TbFormField.TB11_IPT_COLUMN3_FEMALE
    };

    /**
     * @return an array containing the fields of the report in question
     */
    @Override
    protected TbFormField[] getFields() {
        return fields;
    }

    /**
     * @return the report name to be set on transaction log
     */
    @Override
    protected String getReportName() {
        return messages.get("manag.tbform11");
    }

    /**
     * @return the DTO class that stores the values
     */
    @Override
    public TB11InputFormData getData() {
        if (this.data == null) {
            this.data = new TB11InputFormData();
        }
        return data;
    }
}
